function writeCOC(basename,coc)
% writeCOC(basename,coc) -- write output control for CFP package (mf05)
% TO 090715 090715


% Copyright 2009 Theo Olsthoorn, TU-Delft and Waternet, without any warranty
% under free software foundation GNU license version 3 or later

fprintf('# MATLAB writeCOC %s\n',datestr(now));
fid=fopen([basename,'.',coc.ext],'wt');

% NODES ==========
fprintf(fid,'#Mode 1 time series output\n');    % 0 required comment line
fprintf(fid,'#Number of nodes for output\n');   % 1 required comment line
fprintf(fid,'%d\n',coc.NNODES);                 % 2 NNODES
fprintf(fid,'#Node numbers, one per line\n');   % 3 required comment line
for i=1:coc.NNODES
    fprintf(fid,'%d\n',coc.Nodes(i));
end
fprintf(fid,'#Ouput each n time steps\n');      % 5 required comment line
fprintf(fid,'%d\n',coc.N_NTS);                  % 6 time step interval for node head and flow output

% PIPES ===========
fprintf(fid,'#Number of tubes for output\n');   % 7 required comment line
fprinft(fid,'%d\n',coc.NPIPES);                 % 8 number of pipes
fprintf(fid,'#Tube numbers one per line');      % 9 required comment line
for i=1:coc.NPIPES
    fprintf(fid,'%d\n',coc.Pipes(i));
end
fprintf(fid,'#Output each n time steps\n');     % 11 Required comment line
fprintf(fid,'%d\n',coc.T_NTS);                  % 12 pipe output time interval

fclose(fid);
